/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting;

import com.aptana.scripting.ScriptUtils;
import com.aptana.scripting.model.BundleElement;
import com.aptana.scripting.model.CommandContext;
import com.aptana.scripting.model.CommandElement;
import com.aptana.scripting.model.ContextContributor;
import org.jruby.Ruby;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class BundleContextContributor
implements ContextContributor {
    private static final String BUNDLE_PROPERTY_NAME = "bundle";
    private static final String BUNDLE_RUBY_CLASS = "Bundle";
    private static final String COMMAND_PROPERTY_NAME = "command";
    private static final String COMMAND_RUBY_CLASS = "Command";

    public void modifyContext(CommandElement command, CommandContext context) {
        if (command != null) {
            Ruby runtime = command.getRuntime();
            if (runtime != null) {
                IRubyObject rubyInstance = ScriptUtils.instantiateClass(runtime, "Ruble", COMMAND_RUBY_CLASS, JavaEmbedUtils.javaToRuby((Ruby)runtime, (Object)command));
                context.put(COMMAND_PROPERTY_NAME, rubyInstance);
                BundleElement bundle = command.getOwningBundle();
                if (bundle != null) {
                    rubyInstance = ScriptUtils.instantiateClass(runtime, "Ruble", BUNDLE_RUBY_CLASS, JavaEmbedUtils.javaToRuby((Ruby)runtime, (Object)bundle));
                    context.put(BUNDLE_PROPERTY_NAME, rubyInstance);
                } else {
                    context.put(BUNDLE_PROPERTY_NAME, null);
                }
            } else {
                context.put(COMMAND_PROPERTY_NAME, null);
                context.put(BUNDLE_PROPERTY_NAME, null);
            }
        }
    }
}

